%clc;

% === Target ===    
      %%% ! SCEGLIERE QUI IL TARGET DEL SUPERCAPACITORE ! %%%

Vmax = 3.3;           % Tensione massima di operatività del carico [V]
Vmin = 1.8;           % Tensione minima di operatività del carico [V]
Iload = 10e-6;        % Corrente richiesta dal carico [A]
Autonomy = 17*3600;   % Autonomia desiderata nell'alimentazione del carico in un caso ideale senza perdite [s]

Q_target = Iload * Autonomy;   % Carica minima necessaria del supercap per soddisfare l'autonomia richiesta [C]

C_need = Q_target/(Vmax-Vmin); % Capacità necessaria per mantenere l'autonomia nella dinamica del carico
C_need = round (C_need,3);
%C_need = ***** ;              % Impostazione diretta della capacità deisderata

Qmin = C_need*Vmin;            % Carica necessaria a raggiungere Vmin
Qmax = Q_target + Qmin;        % Carica necessaria a raggiungere Vmax

      %%% ! FINE SCELTA DEL TARGET DEL SUPERCAPACITORE ! %%%

% === Valori iniziali (dal paper di Cabrane) ===
Rf = 15e6;                 
R1 = 0.008; 
R2 = 1; 
C0 = 2170;  
Cv = 520;    
C2 = 150;

% === Fattore di scalamento k ===
Q1_old = C0*Vmax + 0.5*Cv*Vmax^2;
Q2_old = C2*Vmax;
k = Qmax / (Q1_old + Q2_old);

% === Capacità scalate ===
C0_new = k*C0;
C0_new = round (C0_new,3);
Cv_new = k*Cv;
Cv_new = round (Cv_new,3);
C2_new = k*C2;
C2_new = round (C2_new,3);
C1_max_new = C0_new + Cv_new*Vmax;
C1_max_new = round (C1_max_new,3);

% === Cariche scalate ===
Q1_new = C0_new*Vmax + 0.5*Cv_new*Vmax^2;
Q2_new = C2_new*Vmax;

% === Resistenze scalate per mantenere le stesse tau ===
R1_new = R1 / k;   
R1_new = round (R1_new,1);
R2_new = R2 / k;
R2_new = round (R2_new,1);
Rf_new = Rf / k;  

% === Costanti di tempo tau scalate ===
Tau1_max = R1_new*C1_max_new;
Tau2 = R2_new*C2_new;

%------------------------------------------------------------------------

fprintf('\n');
fprintf('Riassunto delle variazioni nei parametri del supercap:\n');
fprintf('\n');

disp(table([Rf Rf_new]', [R1 R1_new]', [R2 R2_new]', [C0 C0_new]', [Cv Cv_new]', [C2 C2_new]', ...
    'VariableNames', {'Rf[Ω]', 'R1[Ω]','R2[Ω]','C0[F]','Cv[F]','C2[F]'}, 'RowNames', {'old','new'}));

disp(table(Iload', Autonomy/3600', Vmax', Q_target', Qmax', C_need', ...
    'VariableNames', {'Iload[I]', 'Autonomy[ore]', 'Vmax[V]', 'Q_target[C]', 'Qmax[C]', 'C_need[F]'}, 'RowNames', {'chosen parameters'}));

fprintf('\n');
fprintf('Copiare e incollare questi parametri su Simulazioni.m \n'); % --- Parametri calibrati del supercap (SI) --- 
fprintf('nella sezione: --- Parametri calibrati del supercap (SI) --- \n');
fprintf('------------------------------------\n');
fprintf('C_need = %.12g;\n',C_need);
%fprintf('Rf = %.3e;\n',Rf_new);
fprintf('R1 = %.12g;\n',R1_new);
fprintf('R2 = %.12g;\n',R2_new);
fprintf('C0 = %.12g;\n',C0_new);
fprintf('Cv = %.12g;\n',Cv_new);
fprintf('C2 = %.12g;\n',C2_new);
fprintf('------------------------------------\n');
fprintf('\n');

